<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pelanggans', function (Blueprint $table) {
            $table->id();
            $table->date('tanggal');
            $table->string('nama_pelanggan');
            $table->text('alamat');
            $table->string('no_telepon');
            $table->string('sph_r')->nullable();
            $table->string('cyl_r')->nullable();
            $table->string('axis_r')->nullable();
            $table->string('add_r')->nullable();
            $table->string('pdd_r')->nullable();
            $table->string('sph_l')->nullable();
            $table->string('cyl_l')->nullable();
            $table->string('axis_l')->nullable();
            $table->string('add_l')->nullable();
            $table->string('pdd_l')->nullable();
            $table->string('merk_frame');
            $table->decimal('total_bayar', 15, 2)->default(0);
            $table->decimal('dp', 15, 2)->default(0);
            $table->decimal('sisa_pembayaran', 15, 2)->default(0);
            $table->date('tanggal_kirim')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pelanggans');
    }
};
